#include "GlobalExtern.h"

void OptionGUIInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 3;
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionGUISelected++;
		if(OptionGUISelected > OptionGUIItems.size() - 1)
			OptionGUISelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionGUISelected--;
		if(OptionGUISelected < 0)
			OptionGUISelected = OptionGUIItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionGUISelected == 0) {
			GUIState = 10;
			return;
		}
		if(OptionGUISelected == 1) {
			GUIState = 9;
			return;
		}
	}
}

void DrawOptionGUIItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionGUISelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionGUIMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionGUIItems.size(); i++) {
		DrawOptionGUIItem(i, (char*)OptionGUIItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
	}
	Present();
}

void OptionGUIMenu() {
	OptionGUIInput();
	DrawOptionGUIMenu();
}
